/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.stats;

import com.gjhi.tinkersinnovation.TinkersInnovation;
import com.gjhi.tinkersinnovation.library.stats.ShieldMaterialStats;
import com.gjhi.tinkersinnovation.register.TinkersInnovationToolStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record BombCoreStats(float durability, float bomb_radius, float velocity, float accuracy) implements IMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId(TinkersInnovation.getResource("bomb_core"));
    public static final MaterialStatType<ShieldMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new BombCoreStats(0.0f, 1.0f, 0.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("durability", (Object)Float.valueOf(0.0f), true, BombCoreStats::durability), (RecordField)FloatLoadable.FROM_ZERO.defaultField("bomb_radius", (Object)Float.valueOf(1.0f), true, BombCoreStats::bomb_radius), (RecordField)FloatLoadable.ANY.defaultField("velocity", (Object)Float.valueOf(0.0f), true, BombCoreStats::velocity), (RecordField)FloatLoadable.ANY.defaultField("accuracy", (Object)Float.valueOf(0.0f), true, BombCoreStats::accuracy), BombCoreStats::new));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)ToolStats.DURABILITY.getDescription(), (Object)TinkersInnovationToolStats.BOMB_RADIUS.getDescription(), (Object)ToolStats.VELOCITY.getDescription(), (Object)ToolStats.ACCURACY.getDescription());

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(ToolStats.DURABILITY.formatValue(this.durability));
        info.add(TinkersInnovationToolStats.BOMB_RADIUS.formatValue(this.bomb_radius));
        info.add(ToolStats.VELOCITY.formatValue(this.velocity));
        info.add(ToolStats.ACCURACY.formatValue(this.accuracy));
        return info;
    }

    @NotNull
    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float scale) {
        ToolStats.DURABILITY.percent(builder, (double)(this.durability * scale));
        TinkersInnovationToolStats.BOMB_RADIUS.update(builder, Float.valueOf(this.bomb_radius * scale));
        ToolStats.VELOCITY.percent(builder, (double)(this.velocity * scale));
        ToolStats.ACCURACY.percent(builder, (double)(this.accuracy * scale));
    }
}

